subroutine choldc1(a,p)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

implicit none

real*8, dimension(:,:), intent(inout) :: a
real*8, dimension(:),   intent(out)   :: p

integer*4 :: i,n
real*8    :: summ

n=size(a,1)
if(n /= size(a,2)) print*,'failure in choldc1'
if(n /= size(p)) print*,'failure in choldc1'!

do i=1,n
	summ=a(i,i)-dot_product(a(i,1:i-1),a(i,1:i-1))
	if (summ <= 0.d0) then
	   print*,'choldc1 failed, summ=', summ,' i, a(i,i): ',i,a(i,i)
	   read(*,*)
	   exit
	end if
	p(i)=sqrt(summ)
	a(i+1:n,i)=(a(i+1:n,i)-matmul(a(i+1:n,1:i-1),a(i,1:i-1)))/p(i)
end do
end subroutine choldc1

!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

subroutine cholsl1(a,p,b,x)

implicit none

real*8, dimension(:,:), intent(in) :: a
real*8, dimension(:),   intent(in) :: p, b
real*8, dimension(:),   intent(inout):: x

integer*4 :: i,n

n=size(a,1)

do i=1,n
  x(i)=(b(i)-dot_product(a(i,1:i-1),x(1:i-1)))/p(i)
end do
do i=n,1,-1
  x(i)=(x(i)-dot_product(a(i+1:n,i),x(i+1:n)))/p(i)
end do

end subroutine cholsl1

!===================================================================